﻿#include "functions/nextDepth.as"
EQUIP.accessory.iron_boots = {
	breakSpikes:function( xTile, yTile )
	{
		var spikeId = 3;
		if(MAP.collision_array[xTile][yTile] == spikeId)
		{// if:  hit spikes
			SOUND.play("sound\\spikes.mp3", 50);
			// place break effect
			var newDepth = nextDepth(SPRITES);
			var newName = "block_break_"+newDepth;
			SPRITES.attachMovie("block_break", newName, newDepth, {_x:xTile*16+8, _y:yTile*16+8});
			// remove map tile
			var layers = LEVEL.levelData.map.layers.length;
			for(var l=0; l<layers; l++)
				MAP.setTile(xTile, yTile, 0, l);
			// clear collision
			MAP.collision_array[xTile][yTile] = 0;
		}// if:  hit spikes
	},// hitBlock()
	hurtPlayer:function( damage, hazardType )
	{
		if(hazardType=="spikes")
			RAM.player.hp += damage;		// negate all damage
		// shatter any spikes the payer is touching
		#include "functions/tileLoop.as"
		var playerBounds = PLAYER.hit.getBounds( MAP );
		tileLoop( playerBounds, this.breakSpikes );
	},// hurtPlayer()
	null:null
}// ring object